<?php

return [

    /*
    |--------------------------------------------------------------------------
    | User Model
    |--------------------------------------------------------------------------
    |
    | Define the user model used to associate comments.
    |
    */

    'user_model' => \App\Models\User::class,

	/*
	|--------------------------------------------------------------------------
	| Auto Approve Comments
	|--------------------------------------------------------------------------
	|
	| When set to true, all new reviews will be automatically approved.
	| If false, reviews require manual approval (approved_at remains null).
	|
	*/

	'auto_approve' => true,

	/*
	|--------------------------------------------------------------------------
	| Reviewables mapping
	|--------------------------------------------------------------------------
	|
	| Add reviewable models and map with the corresponding label for info 
	| messages etc.
	|
	| Example:
	| 'AviatorsEcho\Models\Airport' => 'airport',
	|
	*/

	'reviewables' => [
		//
	],

	/*
	|--------------------------------------------------------------------------
	| Caching
	|--------------------------------------------------------------------------
	|
	| When enabled, the comments will be cached using the defined tags.
	|
	*/

	'cache' => [

		// Indicates whether caching is enabled.
		'enabled' => env('CACHING_ENABLED', true),

		// Default cache tags.
		'tag' => 'reviews',

	],

	/*
	|--------------------------------------------------------------------------
	| Styling
	|--------------------------------------------------------------------------
	|
	| Html identifiers for form and table styling.
	|
	*/

	'css' => [

		// Form id selector.
		'form-selector' => 'data-form',

		// Table id selector.
		'form-selector' => 'data-table',
	],

];
