<?php

namespace JLGR\ReleaseNotes\Repositories;

use Illuminate\Database\Eloquent\Collection;
use JLGR\Kernel\Enums\CacheDuration;
use JLGR\Kernel\Repositories\BaseRepository;
use JLGR\ReleaseNotes\Queries\AllReleaseNotes;

class ReleaseNoteRepository extends BaseRepository
{

	/**
	 * Constructor.
	 */
	public function __construct ()
	{
		// Indicates whether caching is enabled.
		$this->useCaching = config('jlgr.release-notes.cache.enabled');

		// Get default cache tags.
		$this->cacheTag = config('jlgr.release-notes.cache.tag');
	}

	/**
     * Get release notes.
     *
     * @param  array  $params
     *
     * @return Collection
     */
    public function getReleaseNotes (array $params = []) : Collection
	{
		return $this->retrieveFromCache(
			cacheKey: "all-releases",
			callback: fn () => AllReleaseNotes::collection($params),
			duration: CacheDuration::SixMonths
		);
	}
	
}
