<?php

namespace JLGR\ReleaseNotes;

use JLGR\ReleaseNotes\Livewire\ReleaseNotesList;
use JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class ReleaseNotesServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's configuration file.
		$this->publishConfigFile();

		// Publish the package's migration file.
		$this->publishMigrations();
		
		// Load views.
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'release-notes');

		// Register Livewire components.
		$this->registerLivewireComponents();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// Register package repository.
		$this->registerRepository();

		// Merge config file.
		$this->mergeConfigFile();
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		// Usage in Blade: <livewire:packages.release-notes.release-notes />
		Livewire::component('release-notes::release-notes-list', ReleaseNotesList::class);
	}

	/**
	 * Register the bug report repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		$this->app->bind(
			ReleaseNoteRepository::class,
			fn ($app) => new ReleaseNoteRepository
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/release-notes.php' => config_path('jlgr/release-notes.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/release-notes.php',
			'jlgr.release-notes'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
