<?php

namespace JLGR\ReleaseNotes\Models;

use JLGR\Kernel\Models\BaseModel;
use JLGR\ReleaseNotes\Models\Release;

class ReleaseNote extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'release_notes';

	/**
	 * The attributes that are protected from mass assignment. An empty
	 * array means all fields are mass assignable.
	 * 
	 * @var array
	 */
	protected $guarded = [];

	/**
	 * The release this note belong to.
	 */
	public function release ()
	{
		return $this->belongsTo(Release::class);
	}

}
