<?php

namespace JLGR\ReleaseNotes\Livewire;

use Illuminate\Database\Eloquent\Collection;
use Livewire\Component;
use JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository;

class ReleaseNotesList extends Component
{

	/**
     * Releases.
     *
     * @var Collection
     */
    public $releaseNotes;

	/**
	 * Mount component.
	 */
	public function mount (ReleaseNoteRepository $releaseNoteRepository)
	{
		$this->releaseNotes = $releaseNoteRepository->getReleaseNotes();
	}

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('release-notes::livewire.release-notes-list.default');
	}

}
