<div class="mt-5 border-t border-gray-200">
	<dl class="sm:divide-y sm:divide-gray-200">

		@foreach($releaseNotes as $version => $release)

			<div class="py-4 sm:grid sm:grid-cols-4 sm:gap-4 sm:py-5">
				<dt class="text-sm">
					<div class="text-base font-bold text-ae-yellow">
						{{ $release->version }}
					</div>
					<div class="text-xs font-medium text-slate-500 mt-1">
						{{ $release->releaseDateForHumans }}
					</div>
				</dt>
				<dd class="mt-1 text-sm text-gray-900 sm:col-span-3 sm:mt-0 space-y-4">

					<div class="">
						<div class="text-base font-bold text-slate-700">
							{{ $release->title }}
						</div>
						<div class="text-default">
							{{ $release->text }}
						</div>
					</div>

					@foreach($release->groupedNotes as $type => $groupedNotes)
						<div class="space-y-1">
							<div class="text-slate-500 font-bold uppercase">
								{{ $type }}
							</div>
							<ul class="list-disc text-md text-slate-700 leading-5 pl-4 space-y-1">
								@foreach($groupedNotes as $note)
									<li>
										{!! $note->text !!}
									</li>
								@endforeach
							</ul>
						</div>
					@endforeach
				</dd>
			</div>
		
		@endforeach

	</dl>
</div>
