<?php

namespace JLGR\MemberPoints\Models;

use AviatorsEcho\Models\BaseModel;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use JLGR\MemberPoints\Enums\MemberPoints;
use JLGR\MemberPoints\Enums\Status;

class MemberPoint extends BaseModel
{
	
	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'member_points';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the attributes that should be cast.
	 *
	 * @return array<string, string>
	 */
	protected function casts () : array
	{
		return [
			'type' => MemberPoints::class,
			'status' => Status::class,
			'is_reversal' => 'boolean',
		];
	}

	/**
	 * Get the user that owns the like.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.member-points.user_model'));
	}

	/**
	 * The pointable entities.
	 */
	public function pointable () : MorphTo
	{
		return $this->morphTo();
	}

	/**
	 * The original point registration this reversal belongs to.
	 */
	public function reversalOf () : BelongsTo
	{
		return $this->belongsTo(self::class, 'reversal_of_id');
	}

}
