<?php

namespace JLGR\MemberPoints\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use JLGR\MemberPoints\Enums\Status;

class RecalculateMemberPointsForUser implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Create a new job instance.
	 * 
	 * @param  integer  $userId
	 * 
	 * @return void
	 */
	public function __construct (protected int $userId)
	{
		$this->onQueue('system');
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void
	{
		$points = DB::table('member_points')
			->where('user_id', $this->userId)
			->where('status', Status::Published->value)
			->sum('points');

		DB::table('users')
			->where('id', $this->userId)
			->update([
				'points' => $points
			]);
	}

}
