<?php

namespace JLGR\MemberPoints\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use JLGR\MemberPoints\Enums\Status;

class PurgeUnpublishedMemberPoints implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Create a new job instance.
	 * 
	 * @return void
	 */
	public function __construct ()
	{
		$this->onQueue('system');
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void
	{
		DB::table('member_points')
			->where('status', Status::Unpublished->value)
			->where('updated_at', '<=', Carbon::now()->subDays(7))
			->delete();
	}

}
