<?php

namespace JLGR\MemberPoints\Enums;

enum MemberPoints : string
{
	// General / system.
    case Registration 				= 'registration';							// Implemented
    case DailyLogin 				= 'daily-login';							// Implemented
    case UserInvitationSent			= 'user-invitation-sent';
    case NewUserFromInvitation		= 'new-user-from-invitation';

	// Flights.
    case FlightCreated				= 'flight-created';
    case GpxAddedToFlight			= 'gpx-added-to-flight';
	case ImageAddedToFlight			= 'image-added-to-flight';

	// Explore >> Airports.
    case AirportSubmitted			= 'airport-submitted';
    case AirportUpdated 			= 'airport-updated';
    case AirportImageAdded 			= 'airport-image-added';

	// Explore >> Entities.
    case EntitySubmitted 			= 'entity-submitted';						// Implemented
    case EntityUpdated 				= 'entity-updated';
    case EntityImageAdded 			= 'entity-image-added';

	// Explore >> Events.
    case EventCreated 				= 'event-created';
    case EventArticleCreated 		= 'event-article-created';
    case EventFaqCreated 			= 'event-faq-created';
    case EventProgramCreated		= 'event-program-created';

	// Account / profile.
    case AccountAvatar 				= 'account-avatar';							// Implemented
    case AccountBiography 			= 'account-biography';						// Implemented
    case AccountHomeAirport			= 'account-home-airport';					// Implemented

	/**
	 * Points library.
	 * 
	 * @return integer
	 */
    public function points () : int
    {
        return match ($this) {
			
			// General / system.
			self::Registration 				=> 10,
			self::DailyLogin 				=> 1,
			self::UserInvitationSent		=> 10,
			self::NewUserFromInvitation		=> 25,

			// Flights.
			self::FlightCreated				=> 5,
			self::GpxAddedToFlight			=> 3,
			self::ImageAddedToFlight		=> 2,

			// Explore >> Airports.
			self::AirportSubmitted			=> 10,
			self::AirportUpdated 			=> 3,
			self::AirportImageAdded 		=> 2,

			// Explore >> Entities.
			self::EntitySubmitted 			=> 10,
			self::EntityUpdated 			=> 3,
			self::EntityImageAdded 			=> 2,

			// Explore >> Events.
			self::EventCreated 				=> 15,
			self::EventArticleCreated 		=> 5,
			self::EventFaqCreated 			=> 2,
			self::EventProgramCreated 		=> 5,

			// Account and profile setup.
			self::AccountAvatar 			=> 10,
			self::AccountBiography 			=> 10,
			self::AccountHomeAirport		=> 10,

        };
    }

}
