<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('member_points', function (Blueprint $table) {
			$table->id();
			$table->foreignId('user_id')->constrained()->onDelete('cascade');
			$table->string('status')->default('published');
			$table->string('type');
			$table->nullableMorphs('pointable');
			$table->integer('points');
			$table->boolean('is_reversal')->default(false);
            $table->foreignId('reversal_of_id')->nullable()->constrained('member_points')->nullOnDelete();
			$table->string('notes')->nullable();
			$table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('member_points');
    }
};
