<?php

namespace JLGR\MemberPoints\Observers;

use JLGR\MemberPoints\Jobs\RecalculateMemberPointsForUser;
use JLGR\MemberPoints\Models\MemberPoint;

class MemberPointObserver
{

	/**
	 * Handle the "created" event.
	 * 
	 * @param  \JLGR\MemberPoints\Models\MemberPoint
	 */
	public function created (MemberPoint $memberPoint) : void
	{
		$this->recalculateMemberPoints($memberPoint);
	}

	/**
	 * Handle the "deleted" event.
	 * 
	 * @param  \JLGR\MemberPoints\Models\MemberPoint
	 */
	public function deleted (MemberPoint $memberPoint) : void
	{
		$this->recalculateMemberPoints($memberPoint);
	}

	/**
	 * Handle the "updated" event.
	 * 
	 * @param  \JLGR\MemberPoints\Models\MemberPoint
	 */
	public function updated (MemberPoint $memberPoint) : void
	{
		$this->recalculateMemberPoints($memberPoint);
	}

	/**
	 * Recalculate member points.
	 * 
	 * @param  MemberPoint  $memberPoint
	 * 
	 * @return void
	 */
	protected function recalculateMemberPoints (MemberPoint $memberPoint) : void
	{
		RecalculateMemberPointsForUser::dispatch($memberPoint->user_id);
	}

}
