<?php

namespace JLGR\MemberPoints;

use Illuminate\Support\ServiceProvider;
use JLGR\MemberPoints\Models\MemberPoint;
use JLGR\MemberPoints\Observers\MemberPointObserver;

class MemberPointsServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's configuration file.
		$this->publishConfigFile();

		// Publish the package's migration file.
		$this->publishMigrations();

		// Register model observers.
		$this->registerObservers();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// // Register package repository.
		// $this->registerRepository();

		// // Merge config file.
		$this->mergeConfigFile();
	}

	/**
	 * Register the bug report repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		// $this->app->bind(
		// 	\JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository::class,
		// 	fn ($app) => new \JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository
		// );
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/member-points.php' => config_path('jlgr/member-points.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/member-points.php',
			'jlgr.member-points'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function registerObservers () : void
	{
		MemberPoint::observe(MemberPointObserver::class);
	}
	
}
