<?php

namespace JLGR\MemberPoints\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

class RecalculateAllMemberPoints implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Create a new job instance.
	 * 
	 * @return void
	 */
	public function __construct ()
	{
		$this->onQueue('system');
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void
	{
		DB::table('users')
			->orderBy('id')
			->chunk(50, function ($users) {
				foreach ($users as $user) {
					RecalculateMemberPointsForUser::dispatch($user->id);
				}
			});
	}

}
