<?php

namespace JLGR\MediaManagement\Tasks;

use Illuminate\Support\Str;
use JLGR\MediaManagement\Models\Media;

/**
 * Update the given media item.
 */
class UpdateMediaItem
{

	/**
	 * Handle task.
	 *
	 * @param Media $media
	 * @param array $data
	 * 
	 * @return void
	 */
	public function handle (Media $media, array $data) : void
	{
		$media->update([
			'status' => $data['status'],
			'notes' => Str::trim($data['notes'] ?? '')
		]);
	}
	
}