<?php

namespace JLGR\MediaManagement\Tasks;

use JLGR\MediaManagement\Models\Media;

/**
 * Move the given media item to the destination model.
 */
class MoveMediaToDestinationModel
{

	/**
	 * Handle task.
	 *
	 * @param Media $mediaItem
	 * 
	 * @return void
	 */
	public function handle (Media $mediaItem) : void
	{
		$hostModel = $mediaItem->model;

		$mediaItem->move($hostModel, 'images', 'digital-ocean');
	}
	
}