<?php

namespace JLGR\MediaManagement\Tasks;

use JLGR\MediaManagement\Models\Media;
use JLGR\MemberPoints\Enums\MemberPoints;
use JLGR\MemberPoints\MemberPointService;

/**
 * Grant user points for the given media item.
 */
class GrantUserPoints
{

	/**
	 * Construct task.
	 */
	public function __construct (
		protected MemberPointService $memberPointService
	) {}

	/**
	 * Handle task.
	 *
	 * @param Media $mediaItem
	 * @param array $data
	 * 
	 * @return void
	 */
	public function handle (Media $mediaItem, array $data) : void
	{
		if ($data['grant_user_points'] === false) {
			return;
		}
		
		$this->memberPointService
			->forUser($mediaItem->getCustomProperty('user_id'))
			->forType(MemberPoints::AirportImageAdded)
			->withPointable($mediaItem->model)
			->grant();
	}
	
}