<?php

namespace JLGR\MediaManagement\Support;

use Illuminate\Contracts\Container\Container;
use JLGR\MediaManagement\Contracts\MediaUploadHandlerInterface;

class UploadHandlerResolver
{

	/**
	 * Construct resolver.
	 * 
	 * @param  Container  $container
	 */
	public function __construct (
		protected Container $container
	) {}

	/**
	 * Resolve the handler for a given media type.
	 * 
	 * @param  string  $type
	 * 
	 * @return MediaUploadHandlerInterface
	 */
	public function resolve (array $config) : MediaUploadHandlerInterface
	{
		$handlerClass = $config['uploader'];

		/** @var MediaUploadHandlerInterface $handler */
		return $this->container->make($handlerClass);
	}

}
