<?php

namespace JLGR\MediaManagement\Support;

use InvalidArgumentException;

class MediaTypeMapper
{

	/**
	 * Resolve configuration for a given media type.
	 *
	 * @param  string  $type
	 * 
	 * @return array{collection: string, form: class-string, uploader: class-string}
	 */
	public static function resolve (string $type) : array
	{
		$types = config('jlgr.media-management.types');

		if (! isset($types[$type])) {
			throw new InvalidArgumentException("Unknown media type: {$type}");
		}

		return $types[$type];
	}

}
