<?php

namespace JLGR\MediaManagement\Services;

use Illuminate\Database\Eloquent\Model;
use JLGR\MediaManagement\Contracts\MediaUploadHandlerInterface;
use JLGR\MediaManagement\DTOs\UploadContext;
use JLGR\MediaManagement\Models\Media;
use JLGR\MediaManagement\Processors\UploadedImageProcessor;
use JLGR\MediaManagement\Support\MediaTypeMapper;
use JLGR\MediaManagement\Support\UploadHandlerResolver;

class MediaManagerService
{

	/**
	 * Construct service.
	 * 
	 * @param  UploadHandlerResolver  $handlerResolver
	 */
	public function __construct (
		protected UploadedImageProcessor $uploadedImageProcessor,
		protected UploadHandlerResolver $handlerResolver
	) {}

	/**
	 * Upload a media file using the correct handler.
	 *
	 * @param  Model  $model
	 * @param  array  $data
	 * @param  UploadContext  $context
	 * 
	 * @return void
	 */
	public function upload (Model $model, array $data, UploadContext $context) : void
	{
        $config = MediaTypeMapper::resolve($context->type);

        $handler = $this->handlerResolver->resolve($config);
		
        $handler->handle($model, $data, $context);
	}

	/**
	 * Process uploaded image.
	 *
	 * @param Media $media
	 * @param array $data
	 * 
	 * @return void
	 */
	public function processImage (Media $media, array $data) : void
	{
		$this->uploadedImageProcessor->handle($media, $data);
	}

}
