<?php

namespace JLGR\MediaManagement\Services\Handlers;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Auth;
use InvalidArgumentException;
use JLGR\MediaManagement\Contracts\MediaUploadHandlerInterface;
use JLGR\MediaManagement\DTOs\UploadContext;
use JLGR\MediaManagement\Enums\Status;
use Spatie\MediaLibrary\HasMedia;

class ImageUploadHandler implements MediaUploadHandlerInterface
{

	/**
	 * Handle uploading and attaching the media to the model.
	 * 
	 * @param  Model  $model
	 * @param  array  $data
	 * @param  UploadContext  $context
	 * 
	 * @return void
	 */
	public function handle (Model $model, array $data, UploadContext $context) : void
	{
		if (!$model instanceof HasMedia) {
			throw new InvalidArgumentException('Model must implement HasMedia.');
		}

		$disk = config('jlgr.media-management.default-disk', 'digital-ocean');

		foreach ($data['media'] ?? [] as $file)
		{
			$newMediaItem = $model
				->addMedia($file)
				->usingName($file->getClientOriginalName())
				->withCustomProperties($context->customProperties)
				->toMediaCollection($context->collection, $disk);

			$newMediaItem->update([
				'status' => Status::New->value
			]);
		}
	}
	
}
