<?php

namespace JLGR\MediaManagement\Processors;

use JLGR\MediaManagement\Enums\Status;
use JLGR\MediaManagement\Models\Media;
use JLGR\MediaManagement\Tasks\GrantUserPoints;
use JLGR\MediaManagement\Tasks\MoveMediaToDestinationModel;
use JLGR\MediaManagement\Tasks\UpdateMediaItem;

/**
 * Process uploaded image.
 */
class UploadedImageProcessor
{

	/**
	 * Construct processor.
	 */
	public function __construct (
		protected GrantUserPoints $grantUserPoints,
		protected MoveMediaToDestinationModel $moveMediaToDestinationModel,
		protected UpdateMediaItem $updateMediaItem,
	) {}

	/**
	 * Handle processor tasks.
	 *
	 * @param Media $media
	 * @param array $data
	 * 
	 * @return void
	 */
	public function handle (Media $media, array $data) : void
	{
		$this->updateMediaItem->handle($media, $data);

		if ($data['status'] === Status::Accepted->value)
		{
			$this->moveMediaToDestinationModel->handle($media);

			$this->grantUserPoints->handle($media, $data);
		}
	}

}