<?php

namespace JLGR\MediaManagement\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use JLGR\MediaManagement\Enums\Status;
use Spatie\MediaLibrary\MediaCollections\Models\Media as SpatieMedia;

class Media extends SpatieMedia
{

	/**
     * Scope a query to include new and unprocessed media.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    public function scopeWhereNew ($query)
	{
		return $query->where('status', Status::New->value);
	}

	/**
     * Scope a query to include user submitted media.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    public function scopeWhereUserSubmitted ($query)
	{
		return $query->where('collection_name', 'user-submissions');
	}

	/**
	 * Get the user that sent this invitation.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.media-management.user_model'));
	}

    /**
     * Get the class name (without namespace) of the related model.
     *
     * @return string
     */
    public function getModelClassNameAttribute(): string
    {
        // Returns something like "Airport" extracted from "AviatorsEcho\Models\Airport".
        return class_basename($this->model_type);
    }

}