<?php

namespace JLGR\MediaManagement;

use JLGR\MediaManagement\Livewire\MediaUploader;
use Illuminate\Support\ServiceProvider;
use JLGR\MediaManagement\Support\UploadStrategyResolver;
use Livewire\Livewire;

class MediaManagementServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's configuration file.
		$this->publishConfigFile();
		
		// Load views.
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'media-management');

		// Register Livewire components.
		$this->registerLivewireComponents();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// Merge config file.
		$this->mergeConfigFile();

		// Register dependencies.
        $this->app
			->singleton(UploadStrategyResolver::class, fn ($app)
				=> new UploadStrategyResolver($app));
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		// Usage in Blade: <livewire:media-management::media-uploader />
		Livewire::component('media-management::media-uploader', MediaUploader::class);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/media-management.php' => config_path('jlgr/media-management.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/media-management.php',
			'jlgr.media-management'
		);
	}

}
