<?php

namespace JLGR\MediaManagement\Filament\Forms;

use Filament\Schemas\Schema;
use Filament\Schemas\Components\Grid;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\{ Components, Form };

class ImageUploaderFormBuilder
{

	/**
     * Build edit form.
     *
     * @param Schema $schema
     * @param  array  $context
     *
     * @return Schema
     */
    public static function make (Schema $schema, array $context) : Schema
	{
		return $schema
			->components(self::getElements($context))
			->statePath('data');
	}

	/**
	 * Get form elements.
	 * 
	 * @param  array  $context
	 * 
	 * @return array
	 */
	private static function getElements (array $context) : array
	{
		return [
			Grid::make(5)
				->schema([
					FileUpload::make('media')
						->label(false)
						->columnSpanFull()
						->maxSize($context['maxSize'])
						->required()
						->multiple($context['multiple'])
						->acceptedFileTypes($context['acceptedMimes'])
						->validationMessages([
							'required' => __('Select at least 1 image.'),
							'maxSize' => __("The file size should not exceed {$context['maxSize']}kB."),
						]),
				])
		];
	}

}
