<?php

namespace JLGR\MediaManagement\Enums;

enum Status : string
{

	case New 		= 'new';
	case Processed 	= 'processed';
	case OnHold 	= 'on-hold';
	case Accepted 	= 'accepted';
	case Rejected 	= 'rejected';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::New		=> __('New'),
			self::Processed	=> __('Processed'),
			self::OnHold	=> __('On-hold'),
			self::Accepted	=> __('Accepted'),
			self::Rejected	=> __('Rejected'),
		};
	}
	
	/**
	 * Find the enum case by the category key.
	 *
	 * @param  string  $key
	 * 
	 * @return self|null
	 */
	public static function fromKey (string $key) : ?self
	{
		return self::tryFrom($key);
	}

}
