<?php

namespace JLGR\MediaManagement\DTOs;

class UploadContext
{

	/**
	 * DTO attributes.
	 */
	public function __construct(
		public string $type,
		public string $collection,
		public bool $multiple = false,
		public array $acceptedMimes = [],
		public int $maxSize = 512,
		public array $customProperties = [],
		public ?string $disk = null,
	) {}

	/**
	 * Returns true if multiple uploads are allowed.
	 * 
	 * @return boolean
	 */
	public function allowsMultiple () : bool
	{
		return $this->multiple;
	}

	/**
	 * Returns the disk to use.
	 * 
	 * @return string
	 */
	public function getDisk () : string
	{
		return $this->disk ?? config('jlgr.media-management.default-disk', 'digital-ocean');
	}

	/**
	 * Convert DTO to an array.
	 * 
	 * @param  array  $data
	 * 
	 * @return self
	 */
	public function toArray () : array
	{
		return [
			'type' => $this->type,
			'collection' => $this->collection,
			'multiple' => $this->multiple,
			'acceptedMimes' => $this->acceptedMimes,
			'maxSize' => $this->maxSize,
			'customProperties' => $this->customProperties,
			'disk' => $this->disk,
		];
	}

	/**
	 * Populate DTO from the given array.
	 * 
	 * @param  array  $data
	 * 
	 * @return self
	 */
	public static function fromArray (array $data) : self
	{
		return new self(
			type: $data['type'],
			collection: $data['collection'],
			multiple: $data['multiple'] ?? false,
			acceptedMimes: $data['acceptedMimes'] ?? [],
			maxSize: $data['maxSize'] ?? 512,
			customProperties: $data['customProperties'] ?? [],
			disk: $data['disk'] ?? null
		);
	}

}
