<?php

namespace JLGR\MediaManagement\Contracts;

use Illuminate\Database\Eloquent\Model;
use JLGR\MediaManagement\DTOs\UploadContext;

interface MediaUploadHandlerInterface
{
	
	/**
	 * Handle uploading and attaching the media to the model.
	 * 
	 * @param  Model  $model
	 * @param  array  $data
	 * @param  UploadContext  $context
	 * 
	 * @return void
	 */
	public function handle (Model $model, array $data, UploadContext $context) : void;
	
}
