<?php

return [

	/**
	 * Default disk for storing media uploads.
	 */
	'default-disk' => env('MEDIA_DISK', 'digital-ocean'),
	
	/**
	 * Media upload types.
	 */
	'types' => [

		'images' => [
			'collection' => 'images',
			'form'       => \JLGR\MediaManagement\Filament\Forms\ImageUploaderFormBuilder::class,
			'uploader'   => \JLGR\MediaManagement\Services\Handlers\ImageUploadHandler::class,
		],

		'gpx' => [
			'collection' => 'gpx',
			'form'       => \JLGR\MediaManagement\Filament\Forms\GpxUploaderFormBuilder::class,
			'uploader'   => \JLGR\MediaManagement\Services\Handlers\GpxUploadHandler::class,
		],

	],

	/**
	 * Caching.
	 */
	'cache' => [

		// Indicates whether caching is enabled.
		'enabled' => env('CACHING_ENABLED', true),

		// Default cache tags.
		'tag' => 'media-manager',

	],

	/**
	 * Styling.
	 */
	'css' => [

		// Form id selector.
		'form-selector' => 'data-form',

		// Table id selector.
		'form-selector' => 'data-table',
	],
	
];
