<?php

namespace JLGR\Likes\Models;

use Illuminate\Database\Eloquent\Relations\MorphTo;
use JLGR\Kernel\Models\BaseModel;

class LikeStatistic extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'like_statistics';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the parent likeable model (flight, etc).
	 */
	public function likeable () : MorphTo
	{
		return $this->morphTo();
	}

}
