<?php

namespace JLGR\Likes\Models;

use Illuminate\Database\Eloquent\Relations\{ BelongsTo, MorphTo };
use JLGR\Kernel\Models\BaseModel;

class Like extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'likes';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the parent likeable model (flight, etc).
	 */
	public function likeable () : MorphTo
	{
		return $this->morphTo();
	}

	/**
	 * Get the user that owns the like.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.likes.user_model'));
	}

}
