<?php

namespace JLGR\Likes\Livewire;

use JLGR\Likes\Contracts\TogglesLike;
use Livewire\Component;

class LikeButton extends Component
{

	/**
	 * The likeable model.
	 * 
	 * @var mixed
	 */
	public mixed $likeable;

	/**
	 * Component properties.
	 * 
	 * @var mixed
	 */
	public string $template = 'default';

	/**
	 * Button state indicating whether the likeable has been
	 * liked or not.
	 * 
	 * @var boolean
	 */

	public bool $liked = false;

	/**
	 * Mount the component with the likeable model.
	 */
	public function mount (mixed $likeable) : void
	{
		$this->likeable = $likeable;

		$this->liked = $likeable->isLiked();
	}

	/**
	 * Toggle like.
	 * 
	 * @param  TogglesLike  $likeProcessor
	 * 
	 * @return void
	 */
	public function toggleLike (TogglesLike $likeProcessor) : void
	{
		$likeProcessor->handle($this->likeable);
		$this->liked = !$this->liked;

		$this->dispatch('like-toggled');
	}

	/**
	 * Render the component.
	 */
	public function render ()
	{
		return view("likes::livewire.like-button.{$this->template}");
	}

}
