<?php

namespace JLGR\Likes;

use JLGR\Likes\Contracts\AddsLike;
use JLGR\Likes\Actions\AddLike;
use JLGR\Likes\Contracts\TogglesLike;
use JLGR\Likes\Actions\ToggleLike;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use JLGR\Likes\Actions;
use JLGR\Likes\Contracts;
use JLGR\Likes\Livewire as LivewireComponents;
use Livewire\Livewire;

class LikesServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// // Publish the package's configuration file.
		$this->publishConfigFile();

		// // Publish the package's migration file.
		$this->publishMigrations();
		
		// // Load views.
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'likes');

		// // Register Livewire components.
		$this->registerLivewireComponents();

		// Register Blade directives.
		$this->registerBladeDirectives();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// // Register package repository.
		// $this->registerRepository();

		// // Merge config file.
		$this->mergeConfigFile();

		// Register action bindings.
		$this->registerActionBindings();
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		$this->app->singleton(AddsLike::class, AddLike::class);
		$this->app->singleton(TogglesLike::class, ToggleLike::class);
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		Livewire::component('likes::like-button', LivewireComponents\LikeButton::class);
		Livewire::component('likes::likers', LivewireComponents\Likers::class);
	}

	/**
	 * Register the bug report repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		// $this->app->bind(
		// 	\JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository::class,
		// 	fn ($app) => new \JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository
		// );
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/likes.php' => config_path('jlgr/likes.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/likes.php',
			'jlgr.likes'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

	/**
	 * Register Blade directives.
	 * 
	 * @return void
	 */
	protected function registerBladeDirectives () : void
	{
		Blade::if('canLike', function ($likeable = null) {
			$user = Auth::user();

			if (! $user || ! $likeable) {
				return false;
			}

			if (
				method_exists($likeable, 'user') &&
				($owner = $likeable->user()?->getResults()) &&
				$owner->id === $user->id
			) {
				return false; // Self-like: not allowed
			}

			return true;
		});
	}

}
