<div class="flex items-center gap-2">

	@php
		$avatarAttribute = config('jlgr.likes.avatar-attribute', 'avatar');	
	@endphp

	{{-- AVATAR STACK --}}
	@if ($likesCount > 0)
		<div class="isolate flex -space-x-2 overflow-hidden">
			@foreach ($likes as $like)
				<img
					src="{{ $like->user->{$avatarAttribute} }}"
					alt="{{ $like->user->name }}"
					class="relative inline-block size-6 rounded-full ring-2 ring-white"
					style="z-index: {{ 50 - $loop->index }}"
				/>
			@endforeach
		</div>
	@endif
	
	{{-- TOTAL NUMBER OF LIKES --}}
	@if ($showLikesCount)
		<div class="text-slate-700 text-sm">
			@if ($likesCount > 0)
				{{ $likesCount }} {{ __('likes') }}
			@else
				{{ __('0 likes, be the first!') }}
			@endif
		</div>
	@endif

</div>