<?php

return [

	/*
	|--------------------------------------------------------------------------
	| User Model
	|--------------------------------------------------------------------------
	|
	| Define the user model used to associate comments.
	|
	*/

	'user_model' => \App\Models\User::class,

	/*
	|--------------------------------------------------------------------------
	| Avatar url attribute on the user model
	|--------------------------------------------------------------------------
	|
	| Define the user model used to associate comments.
	|
	*/

	'avatar-attribute' => null,

	/*
	|--------------------------------------------------------------------------
	| Caching
	|--------------------------------------------------------------------------
	|
	| When enabled, the comments will be cached using the defined tags.
	|
	*/

	'cache' => [

		// Indicates whether caching is enabled.
		'enabled' => env('CACHING_ENABLED', true),

		// Default cache tags.
		'tag' => 'likes',

	],

	/*
	|--------------------------------------------------------------------------
	| Styling
	|--------------------------------------------------------------------------
	|
	| Html identifiers for form and table styling.
	|
	*/

	'css' => [

		// Form id selector.
		'form-selector' => 'data-form',

		// Table id selector.
		'form-selector' => 'data-table',
	],

];
