<?php

namespace JLGR\Kernel\Enums;

enum CacheDuration : int
{

	// All duration in minutes.
	case TenMinutes = 10;
	case ThirtyMinutes = 30;
	case OneHour = 60;
	case TwoHours = 120;			// 2 * 60
	case FourHours = 240;			// 4 * 60
	case SixHours = 360;			// 6 * 60
	case TwelveHours = 720;			// 12 * 60
	case OneDay = 1440;				// 24 * 60
	case OneWeek = 10080;			// 24 * 60 * 7
	case OneMonth = 43200;			// 24 * 60 * 7 * 30
	case TwoMonths = 86400;			// 24 * 60 * 7 * 30 * 2
	case ThreeMonths = 129600;		// 24 * 60 * 7 * 30 * 3
	case SixMonths = 259200;		// 24 * 60 * 7 * 30 * 6
	case OneYear = 525600;			// 24 * 60 * 365
	
}