<?php

namespace JLGR\InspiringQuotes\Services;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use JLGR\InspiringQuotes\Models\InspiringQuote;

class InspiringQuotes
{

	/**
	 * Check if there are quotes available.
	 * 
	 * @return boolean
	 */
	public function available () : bool
	{
		return InspiringQuote::whereEnabled()->count() > 0;
	}

	/**
	 * Get random quote.
	 * 
	 * @return InspiringQuote|null
	 */
	public function getRandomQuote () : InspiringQuote|null
	{
		try
		{
			return InspiringQuote::query()
				->whereEnabled()
				->inRandomOrder()
				->firstOrFail();
		}
		catch (ModelNotFoundException $exception)
		{
			return null;
		}
	}

}
