<?php

namespace JLGR\InspiringQuotes;

use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class InspiringQuotesServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's configuration file.
		$this->publishConfigFile();

		// Publish the package's migration file.
		$this->publishMigrations();
		
		// Load views.
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'inspiring-quotes');

		// Register Livewire components.
		$this->registerLivewireComponents();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// Merge config file.
		$this->mergeConfigFile();
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		// Random quote component.
		Livewire::component('inspiring-quotes::random-quote', \JLGR\InspiringQuotes\Livewire\RandomQuote::class);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/inspiring-quotes.php' => config_path('jlgr/inspiring-quotes.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/inspiring-quotes.php',
			'jlgr.inspiring-quotes'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
