<?php

namespace JLGR\InspiringQuotes\Enums;

enum Status : string
{

	// Cases...
	case Draft    	= 'draft';
	case Enabled    = 'enabled';
	case Disabled   = 'disabled';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::Draft 	=> __('Draft'),
			self::Enabled	=> __('Enabled'),
			self::Disabled	=> __('Disabled'),
		};
	}

}
