<?php

namespace JLGR\InspiringQuotes\Console;

use JLGR\InspiringQuotes\Models\InspiringQuote;
use Illuminate\Console\Command;

class SeedQuotes extends Command
{

	/**
	 * The console command name.
	 * 
	 * To apply: php artisan points:action Account/Registration --points=5 --key=registration
	 *
	 * @var string
	 */
	protected $signature = 'jlgr:seed-inspiring-quotes';

	/**
	 * The console command description.
	 *
	 * @var string
	 */
	protected $description = 'Seed basic set of inspiring quotes.';

	/**
	 * Execute the console command.
	 *
	 * @return void
	 */
	public function handle ()
	{
		// Load quotes from the CSV source file.
		$quotes = $this->loadQuotesFromCsvFile();

		// Iterate over the quotes and add each of them to the database.
		$quotes
			->each(fn ($quote)
				=> $this->createQuote($quote));
		
		// Done.
		$this->info('All done. Quotes seeded.');
	}

	/**
	 * Open csv source file.
	 * 
	 * @return Illuminate\Support\Collection
	 */
	private function loadQuotesFromCsvFile ()
	{
		// Path to source file.
		$filePath = __DIR__ . '/../resources/examples/inspiring_quotes.csv';

		// Empty collection to hold the quotes.
		$dataCollection = collect();

		// Check if the file exists.
		if (file_exists($filePath))
		{
			if (($handle = fopen($filePath, 'r')) !== false)
			{
				// Read the headers, if the CSV has them.
				$headers = fgetcsv($handle, 1000, ',');

				// Iterate over the rows and add to the collection.
				while (($data = fgetcsv($handle, 1000, ',')) !== false)
				{
					// Combine headers and row data into an associative array
					$row = $headers ? array_combine($headers, $data) : $data;

					// Add each row as an indexed array
					$dataCollection->push($row);
				}
				fclose($handle);
			} else {
				echo "Unable to open the file.";
			}
		} else {
			echo "File not found at: $filePath";
		}

		// Return the quotes.
		return $dataCollection;
	}

	/**
	 * Create quote.
	 * 
	 * @param  array  $quote
	 * 
	 * @return void
	 */
	private function createQuote ($quote)
	{
		InspiringQuote::create([
			'status' => 'enabled',
			'author' => $quote['author'],
			'text' => $quote['text'],
			'source' => $quote['source'],
		]);
	}

}