<?php

namespace JLGR\InspiringQuotes\Models;

use Illuminate\Database\Eloquent\Builder;
use JLGR\Kernel\Models\BaseModel;
use JLGR\InspiringQuotes\Enums\Status;

class InspiringQuote extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'inspiring_quotes';

	/**
	 * The attributes that are protected from mass assignment. An empty
	 * array means all fields are mass assignable.
	 * 
	 * @var array
	 */
	protected $guarded = [];

	/**
     * Useful local query scopes.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    public function scopeWhereEnabled ($query) { return $query->where('status', Status::Enabled->value); }

}
