<?php

namespace JLGR\InspiringQuotes\Livewire;

use JLGR\InspiringQuotes\Models\InspiringQuote;
use JLGR\InspiringQuotes\Services\InspiringQuotes;
use Livewire\Component;

class RandomQuote extends Component
{

	/**
	 * The selected random quote.
	 * 
	 * @var InspiringQuote
	 */
	public $quote;

	/**
	 * Template.
	 * 
	 * @var string
	 */
	public $template = 'default';

	/**
	 * Mount the widget.
	 * 
	 * @return void
	 */
	public function mount ($template = 'default', InspiringQuotes $inspiringQuotesService) : void
	{
		if ($this->quote = $inspiringQuotesService->getRandomQuote()) {
			$this->quote->increment('hits');
		}

		$this->template = $template;
	}

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('inspiring-quotes::livewire.random-quote.' . $this->template);
	}

}
