<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use JLGR\InspiringQuotes\Enums\Status;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inspiring_quotes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained('users')->cascadeOnDelete();
            $table->enum('status', [
                Status::Draft->value,
                Status::Enabled->value,
                Status::Disabled->value,
            ])->default(Status::Draft->value);
            $table->string('author')->nullable();
            $table->text('text')->nullable();
            $table->string('source')->nullable();
            $table->text('notes')->nullable();
            $table->boolean('quote_of_the_week')->default(FALSE);
            $table->integer('hits')->default(0);
            $table->integer('points_granted')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inspiring_quotes');
    }
};
