<?php

namespace JLGR\FriendInvitations\Services;

use JLGR\FriendInvitations\Models\FriendInvitation;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class InvitationService
{

	/**
	 * Check if an invitation exists within the past year for the given user and friend email.
	 *
	 * @param  string  $friendEmail
	 * 
	 * @return boolean
	 */
	public function invitationExistsWithinYear ($friendEmail) : bool
	{
		$oneYearAgo = Carbon::now()->subYear();

		return FriendInvitation::query()
			->where('user_id', Auth::user()->id)
			->where('friend_email', $friendEmail)
			->where('created_at', '>=', $oneYearAgo)
			->exists();
	}

	/**
	 * Format e-mail text by replacing the placeholders.
	 * 
	 * @param  array  $input
	 * 
	 * @return string
	 */
	public function formatEmailText ($input) : string
	{
		// Text template.
		$template = trim($input['text']);

		// Replacement values.
		$replacements = [
			'@friend' => trim($input['friend_name']),
			'@name' => Auth::user()->name,
			'@app' => config('app.name'),
		];

		// Replace placeholders.
		foreach ($replacements as $placeholder => $realValue)
		{
			$template = Str::replace($placeholder, $realValue, $template);
		}
		
		// All done.
		return $template;
	}

	/**
	 * Store the given e-mail text as template on the user's settings.
	 * 
	 * @param  array  $input
	 * 
	 * @return void
	 */
	public function storeTemplate ($input) : void
	{
		$template = trim($input['text']);

		Auth::user()->settings([
			'invitation-email' => $template
		]);
	}
	
}
