<?php

namespace JLGR\FriendInvitations\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use JLGR\Kernel\Models\BaseModel;

class FriendInvitation extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'friend_invitations';

	/**
	 * The attributes that are protected from mass assignment. An empty
	 * array means all fields are mass assignable.
	 * 
	 * @var array
	 */
	protected $guarded = [];

	/**
	 * Get the user that sent this invitation.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.friend-invitations.user_model'));
	}

}
