<?php

namespace JLGR\FriendInvitations\Mail;

use Illuminate\Mail\Mailables\Attachment;
use JLGR\FriendInvitations\Models\FriendInvitation;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class FriendInvitationSent extends Mailable implements ShouldQueue
{
	use Queueable, SerializesModels;

    /**
     * The invitation instance.
     */
    protected FriendInvitation $invitation;

    /**
     * The email code, if any.
     */
    protected ?string $emailCode;

	/**
	 * Create a new message instance.
	 */
	public function __construct (FriendInvitation $invitation, ?string $emailCode = null)
	{
		$this->invitation = $invitation;
		$this->emailCode = $emailCode;

		// Set the queue name for this mailable.
		$this->onQueue('email');
	}

	/**
	 * Get the message envelope.
	 */
	public function envelope () : Envelope
	{
		return new Envelope(
			subject: 'Invitation to join my circle on ' . config('app.name')
		);
	}

	/**
	 * Get the message content definition.
	 */
	public function content () : Content
	{
		return new Content(
			markdown: 'friend-invitations::email.friend-invitation-sent',
			with: [
				'invitation' => $this->invitation,
			]
		);
	}

	/**
     * Get the attachments for the message.
     *
     * @return array<int, Attachment>
     */
    public function attachments () : array
	{
		return [];
	}
	
}
