<?php

namespace JLGR\FriendInvitations;

use Livewire\Livewire;
use JLGR\FriendInvitations\Actions\InviteFriend;
use JLGR\FriendInvitations\Contracts\InvitesFriend;
use JLGR\FriendInvitations\Livewire\FriendInvitationForm;
use JLGR\FriendInvitations\Services\InvitationService;
use Illuminate\Support\ServiceProvider;

class FriendInvitationsServiceProvider extends ServiceProvider
{
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		$this->mergeConfigFile();
	
		$this->registerActionBindings();
		
		$this->registerServiceClasses();
	}

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		$this->publishConfigFile();
		$this->publishMigrations();
		
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'friend-invitations');

		$this->registerLivewireComponents();
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		Livewire::component('friend-invitations::friend-invitation-form', FriendInvitationForm::class);
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		$this->app->singleton(InvitesFriend::class, InviteFriend::class);
	}

	/**
	 * Register service classes.
	 * 
	 * @return void
	 */
	protected function registerServiceClasses ()
	{
		$this->app->singleton(InvitationService::class, fn () => new InvitationService);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/friend-invitations.php' => config_path('jlgr/friend-invitations.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/friend-invitations.php',
			'jlgr.friend-invitations'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
