<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use JLGR\FriendInvitations\Enums\Status;

return new class extends Migration
{

    /**
     * Run the migrations.
     */
    public function up () : void
    {
        Schema::create('friend_invitations', function (Blueprint $table) {
            $table->id();
			$table->foreignId('user_id')->constrained('users');
            $table->enum('status', [
                Status::New->value,
                Status::Used->value,
            ])->default(Status::New->value);
            $table->string('friend_name')->nullable();
            $table->string('friend_email')->nullable();
            $table->text('text')->nullable();
			$table->boolean('archived')->boolean();
            $table->timestamps();		
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down () : void
    {
        Schema::dropIfExists('user_alerts');
    }

};
