<?php

namespace JLGR\Followables\Queries;

use AviatorsEcho\Models\User;
use JLGR\Followables\Enums\FollowStatus;
use JLGR\Followables\Queries\BaseQuery;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class SuggestedAviators //extends BaseEloquentQuery
{

	/**
	 * Build a query for fetching the followers of the
	 * authenticated user.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Illuminate\Database\Eloquent\Builder
	 */
	public static function get (array $params = [])
	{
		// Get id's of the authenticated and viewed user.
		$authenticatedUserId = Auth::id();
		$viewedAviatorId = $params['recordId'];

		// Number of suggestions.
		$numberOfSuggestions = $params['number'] ?? 10;
		
		// Friends of the viewed aviator (both followers and followings).
		$viewedAviatorFriends = DB::table('followables')
			->where(fn ($query)
				=> $query
					->where('follower_id', $viewedAviatorId)
					->orWhere('followable_id', $viewedAviatorId))
			->pluck('follower_id', 'followable_id');

		// Convert to array and merge to handle both directions of relationships.
		$userBFriendIds = array_unique(
			array_merge(
				$viewedAviatorFriends->toArray(),
				array_keys($viewedAviatorFriends->toArray())
			)
		);

		// Exclude authenticated user's current followings.
		$usersToExclude = DB::table('followables')
			->where('follower_id', $authenticatedUserId)
			->pluck('followable_id')
			->toArray();

		// 'Self' should also be excluded.
		$usersToExclude[] = $authenticatedUserId;

		// Suggestion list: viewed aviator's friends excluding the authenicated 
		// user's followings.
		$suggestedFriends = array_diff($userBFriendIds, $usersToExclude);

		// Return query to select the suggested friends.
		return User::query()
			->whereIn('id', $suggestedFriends)
			->inRandomOrder()
			->limit($numberOfSuggestions)
			->get();
	}

}