<?php

namespace JLGR\Followables\Queries;

use AviatorsEcho\Models\User;
use JLGR\Followables\Enums\FollowStatus;
use JLGR\Followables\Queries\BaseQuery;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;

class Followings extends BaseQuery
{

	/**
	 * Build a query for fetching the followings of the
	 * authenticated user.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Illuminate\Database\Eloquent\Builder
	 */
	protected static function builder (array $params = []) : Builder
	{
		// Id of the user to get the followers for. If no useId is given, we
		// assume the followers of the authenticated user should be fetched.
		$userId = $params['recordId'] ?? Auth::id();
		
		// Build a query to fetch all followings from the authenticated user.
		$followings = User::query()
		
			// Select all user data.
			->select('users.*')

			// Join over the followables table.
			->join('followables', function ($join) use ($userId)
			{
				$join

					// Build join.
					->on('users.id', '=', 'followables.followable_id')

					// Filter for the authenciated user.
					->where('followables.follower_id', '=', $userId)

					// Only accepted followers.
					->where('followables.status', FollowStatus::FOLLOWING);
			})

			// Ignore users that are scheduled for deletion.
			->whereNull('deletion_scheduled_at')

			// Order by user name.
			->orderBy('name');
			
		// Return the query builder instance.
		return static::newQuery($followings);
	}

}